%% Birsoy Summers (See Kruseman & De Ridder, 1996, Section 12.1)
% Variable-discharge tests and tests in well fields
% The drawdown in a step-drawdown test can be converted to that of a continuous
% test by adapting the time.

clear variables
close all

% Pumping Flow and Periods

EPS=1e-4;
kD=600;
S =0.1;
r =0.2;

Data=[  % m3/h tstart tend (minutes)
25 0 30
50 30 60
75 60 90
100 90 120];

Q=Data(:,1); tStart=Data(:,2); tEnd=Data(:,3);
dQ=[0; diff(Q)];

t=0.001;
for i=1:length(Q)
    t=[t tStart(i)+logspace(-2,log10(tEnd(i)-tStart(i)))];
end

s=zeros(size(t));
for i=1:length(Q)
    I=find(t>tStart(i)+EPS);
    s( I)=s(I)+Q(i)/(4*pi*kD)*expint(r^2*S./(4*kD*(t(I)-tStart(i))));
end
plot(t,s);

%%
Qn=zeros(size(t));
for i=1:length(Q)
    I=find(t>=tStart(i)+EPS);
    Qn(I)=Q(i);
end

tn=zeros(size(t));
beta=ones(size(t));
for i=1:length(Q)-1
    I=find(t> tEnd(  i));
    beta(I)=beta(I).*(t(I)-tStart(i))./(t(I)-tEnd(i)).^(Q(i)./Qn(I));
end

tn=t;
for i=1:length(Q)-1
    I=find(t>tEnd(i));
    tn(I)=(t(I)-tEnd(i));
end

%%
figure
ssd1=1/(4*pi*kD).*expint(r^2*S./(4*kD*beta.*tn));
ssd2=1/(4*pi*kD).*log(2.25*kD.*beta.*tn/(r^2*S));
plot(t,ssd1,'b',t,ssd2,'r');
%plot(t,ssd1,'b',t,ssd2,'r',t,s,'g');
